function channel_input = OFDM_transmitter_new(symbols,N, BlockLength,L)

M = length(symbols)-BlockLength+1;
channel_input = [];

for k= 1:BlockLength:M 
    
    % Pick out blocks of the symbol input, serial to parallel  
    
    parallel_symbols = symbols(k:k+BlockLength-1);
    
    % Take IFFT of each block seperatly
    
    ifft_output = 44100* ifft(parallel_symbols,N);
    
    % Create the cyclic prefix
    
    cyclic_prefix = ifft_output(N-L+1:N);
    
    % Add the cyclic prefix to each block
 
        
    ifft_output_one_block = [cyclic_prefix,ifft_output];
   
    
    % Combine all blocks, parallel to serial

    channel_input = [channel_input, ifft_output_one_block];

end

end